tinymce.PluginManager.add('custombuttons', function(editor, url) {
  if( typeof aQuick.imageLocations !== 'undefined' ){
    editor.addButton('gallery', {
      title: 'Insert gallery',
      onclick: function() {
        editor.windowManager.open({
          title: aQuick.sGalleryType, 
          body: [{type: 'listbox', 'values': aQuick.imageLocations, name: 'title', minWidth:370}],
          onsubmit: function(e) {
            if( aQConf.bMarkExtendedDescription === true ){
              editor.insertContent('<div class="mrk">'+e.data.title+'</div>');
            }
            else{
              editor.insertContent('<p>'+e.data.title+'</p>');
            }
          }
        });
      }
    });
  }
  editor.addButton('break', {
    title: 'Page break',
    onclick: function() {
      if( aQConf.bMarkExtendedDescription === true ){
        editor.insertContent('<div class="mrk">[BREAK]</div>');
      }
      else{
        editor.insertContent('<p>[BREAK]</p>');
      }
    },
  });
  if( typeof aQuick.widgetsIds !== 'undefined' ){
    editor.addButton('quickwidget', {
      title: 'Insert widget',
      onclick: function() {
        editor.windowManager.open({
          title: aQuick.sWidgetType, 
          body: [{type: 'listbox', 'values': aQuick.widgetsIds, name: 'title', minWidth:370}],
          onsubmit: function(e) {
            if( aQConf.bMarkExtendedDescription === true ){
              editor.insertContent('<div class="mrk">'+e.data.title+'</div>');
            }
            else{
              editor.insertContent('<p>'+e.data.title+'</p>');
            }
          }
        });
      }
    });
  }
});