#!/bin/bash

# ===============================
# Tworzenie skrótów
# ===============================

# Katalog pulpitu użytkownika
DESKTOP=$(xdg-user-dir DESKTOP)


# Katalog menu aplikacji
MENU="$HOME/.local/share/applications"

# Katalog, gdzie jest aplikacja (ustawiamy na katalog skryptu)
APPDIR="$(cd "$(dirname "$0")" && pwd)"

mkdir -p "$DESKTOP"
mkdir -p "$MENU"

echo "Tworzenie skrótu na pulpit..."
cat > "$DESKTOP/RigAndLog_SP4THK.desktop" <<EOF
[Desktop Entry]
Name=RigAndLog_SP4THK
Comment=Uruchamia RigAndLog_SP4THK w Wine
Exec=wine "$APPDIR/RigAndLog_SP4THK.exe"
Icon=utilities-terminal
Terminal=false
Type=Application
Categories=Utility;
EOF
chmod +x "$DESKTOP/RigAndLog_SP4THK.desktop"

echo "Tworzenie skrótu w menu aplikacji..."
cat > "$MENU/rigandlog_sp4thk.desktop" <<EOF
[Desktop Entry]
Name=RigAndLog_SP4THK
Comment=Uruchamia RigAndLog_SP4THK w Wine
Exec=wine "$APPDIR/RigAndLog_SP4THK.exe"
Icon=utilities-terminal
Terminal=false
Type=Application
Categories=Utility;
EOF
chmod +x "$MENU/rigandlog_sp4thk.desktop"

echo "Skróty utworzone poprawnie!"

